%------------------------------------------------------------------------------
% File     : NUM800^1 : TPTP v7.4.0. Released v3.7.0.
% Domain   : Number Theory
% Problem  : Some function of two and three is six, and of one and two is two
% Version  : Especial.
% English  :

% Refs     : [BB05]  Benzmueller & Brown (2005), A Structured Set of Higher
%          : [Ben09] Benzmueller (2009), Email to Geoff Sutcliffe
% Source   : [Ben09]
% Names    : Example 1c [BB05]

% Status   : Theorem
% Rating   : 0.71 v7.4.0, 0.89 v7.2.0, 0.88 v7.0.0, 0.86 v6.4.0, 1.00 v6.2.0, 0.86 v6.1.0, 0.71 v6.0.0, 0.86 v5.5.0, 0.83 v5.4.0, 0.80 v5.3.0, 1.00 v5.2.0, 0.80 v4.1.0, 0.67 v4.0.0, 1.00 v3.7.0
% Syntax   : Number of formulae    :   29 (   0 unit;  14 type;  14 defn)
%            Number of atoms       :  117 (  16 equality;  81 variable)
%            Maximal formula depth :   14 (   7 average)
%            Number of connectives :   70 (   0   ~;   0   |;   1   &;  69   @)
%                                         (   0 <=>;   0  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :  102 ( 102   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   15 (  14   :;   0   =)
%            Number of variables   :   34 (   1 sgn;   0   !;   1   ?;  33   ^)
%                                         (  34   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : 
%------------------------------------------------------------------------------
%----Include Church numerals definitions
include('Axioms/NUM006^0.ax').
%------------------------------------------------------------------------------
thf(thm,conjecture,(
    ? [H: ( ( $i > $i ) > $i > $i ) > ( ( $i > $i ) > $i > $i ) > ( $i > $i ) > $i > $i] :
      ( ( ( H @ two @ three )
        = six )
      & ( ( H @ one @ two )
        = two ) ) )).

%------------------------------------------------------------------------------
